﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Kinematics
{
    public class KinematicsObject
    {
        public int NumberOfJoints;
        public double[,] IdentityMatrix = new double[4,4] { {1,0,0,0}, {0,1,0,0}, {0,0,1,0}, {0,0,0,1}};
        public List<JointObject> Joints { get { return m_joints; } }
        public double[,] T { get { return CalculateKinematics(); } }
        
        private List<JointObject> m_joints = new List<JointObject>();
        private double[,] m_t = null;
        private bool IsPuma = false;

        public KinematicsObject()
        {
            Initialize(true, Constants.PUMA_JOINTS);
        }

        public KinematicsObject(bool isPuma, int numOfLinks)
        {
            Initialize(isPuma, numOfLinks);
        }

        private void Initialize(bool isPuma, int numOfLinks)
        {
            NumberOfJoints = numOfLinks;
            IsPuma = isPuma;
            if (isPuma)
            {
                NumberOfJoints = Constants.PUMA_JOINTS;
            }
            m_joints = new List<JointObject>();
            m_t = null;
        }

        public void UploadPuma(double[] thetas)
        {
            m_joints = new List<JointObject>();
            m_joints.Add(new JointObject(90, 0, thetas[0], 0));
            m_joints.Add(new JointObject(0, 0.431800, thetas[1] , 0));
            m_joints.Add(new JointObject(-90 , 0.020300, thetas[2] , 0.150050));
            m_joints.Add(new JointObject(90 , 0, thetas[3], 0.431800));
            m_joints.Add(new JointObject(-90, 0, thetas[4], 0));
            m_joints.Add(new JointObject(0, 0, thetas[5], 0));
        }

        public void UploadCustom(List<JointObject> joints)
        {
            m_joints = new List<JointObject>(joints);
        }

        public double[,] CalculateKinematics()
        {
            if (m_t != null)
                return m_t;

            m_t = m_joints[0].GetArray();
            for (int i =1; i<m_joints.Count; i++)
            {
                m_t = MatrixMultiplication(m_t, m_joints[i].GetArray());
            }
            return m_t;
        }

        public double[,] MatrixMultiplication(double[,] a, double[,] b)
        {
            double[,] c;
            if (a.GetLength(1) == b.GetLength(0))
            {
                c = new double[a.GetLength(0), b.GetLength(1)];
                for (int i = 0; i < c.GetLength(0); i++)
                {
                    for (int j = 0; j < c.GetLength(1); j++)
                    {
                        c[i, j] = 0;
                        for (int k = 0; k < a.GetLength(1); k++) // OR k<b.GetLength(0)
                            c[i, j] = c[i, j] + a[i, k] * b[k, j];
                    }
                }
                return c;
            }
            return null;
        }
    }
}
